/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.datagen;

import dev.ftb.extendedexchange.Matter;
import dev.ftb.extendedexchange.Star;
import dev.ftb.extendedexchange.block.ModBlocks;
import dev.ftb.extendedexchange.item.ModItems;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraftforge.common.data.LanguageProvider;

class ModLangProvider
extends LanguageProvider {
    public ModLangProvider(DataGenerator gen, String modid, String locale) {
        super(gen, modid, locale);
    }

    protected void addTranslations() {
        this.add("itemGroup.extendedexchange", "ExtendedeXchange");
        this.addBlock((Supplier)ModBlocks.ENERGY_LINK, "Energy EMC Link");
        this.addBlock((Supplier)ModBlocks.PERSONAL_LINK, "Personal EMC Link");
        this.addBlock((Supplier)ModBlocks.REFINED_LINK, "Refined EMC Link");
        this.addBlock((Supplier)ModBlocks.COMPRESSED_REFINED_LINK, "Compressed Refined EMC Link");
        for (Matter matter : Matter.VALUES) {
            if (matter.hasMatterItem) {
                this.addItem(matter.getItem(), matter.displayName + " Matter");
            }
            this.addBlock((Supplier)ModBlocks.COLLECTOR.get((Object)matter), matter.displayName + " Energy Collector " + matter.getMK());
            this.addBlock((Supplier)ModBlocks.RELAY.get((Object)matter), matter.displayName + " Anti-Matter Relay " + matter.getMK());
            this.addItem((Supplier)ModItems.COMPRESSED_COLLECTOR.get((Object)matter), matter.displayName + " Compressed Energy Collector " + matter.getMK());
            this.addBlock((Supplier)ModBlocks.POWER_FLOWER.get((Object)matter), matter.displayName + " Power Flower " + matter.getMK());
        }
        this.addBlock((Supplier)ModBlocks.STONE_TABLE, "Stone Transmutation Table");
        this.addBlock((Supplier)ModBlocks.ALCHEMY_TABLE, "Alchemy Table");
        for (Enum enum_ : Star.VALUES) {
            this.addItem((Supplier)ModItems.MAGNUM_STAR.get(enum_), "Magnum Star " + ((Star)enum_).getDisplayName());
            this.addItem((Supplier)ModItems.COLOSSAL_STAR.get(enum_), "Colossal Star " + ((Star)enum_).getDisplayName());
        }
        this.addItem((Supplier)ModItems.FINAL_STAR_SHARD, "Final Star Shard");
        this.addItem((Supplier)ModItems.FINAL_STAR, "The Final Star");
        this.addItem((Supplier)ModItems.KNOWLEDGE_SHARING_BOOK, "Knowledge Sharing Book");
        this.addItem((Supplier)ModItems.ARCANE_TABLET, "Arcane Transmutation Tablet");
        this.add("block.extendedexchange.energy_link.tooltip", "You can use this block to add EMC to your Transmutation Table using Collectors.");
        this.add("block.extendedexchange.personal_link.tooltip", "Like the Basic Energy EMC Link, but also allows to import and export items.");
        this.add("block.extendedexchange.refined_link.tooltip", "Like the Personal EMC Link, but has 1 input slot and 9 output slots. Intended as an automated item storage system for mods like Refined Storage or AE2. Learns items from input slots.");
        this.add("block.extendedexchange.compressed_refined_link.tooltip", "Like the Refined EMC Link, but has 54 output slots.");
        this.add("block.extendedexchange.collector.tooltip", "Server TPS friendly. Generates EMC only once a second.");
        this.add("block.extendedexchange.collector.emc_produced", "Produced EMC: %s/s");
        this.add("block.extendedexchange.relay.tooltip", "Server TPS friendly. Transfers EMC only once a second.");
        this.add("block.extendedexchange.relay.max_transfer", "Max EMC Transfer: %s/s");
        this.add("block.extendedexchange.relay.relay_bonus", "Relay Bonus: %s/s");
        this.add("block.extendedexchange.stone_table.tooltip", "An alternative to ProjectE's Transmutation Table");
        this.add("block.extendedexchange.stone_table.learn", "Learn");
        this.add("block.extendedexchange.stone_table.unlearn", "Unlearn");
        this.add("gui.extendedexchange.stone_table.cant_use", "Can't use this item in Stone Table!");
        this.add("item.extendedexchange.final_star.tooltip", "Infinite EMC source");
        this.add("item.extendedexchange.final_star.pedestal", "Place a chest next to Pedestal and drop an item on top of it to clone it infinitely.");
        this.add("item.extendedexchange.knowledge_sharing_book.tooltip.1", "Sneak + Right-Click to set yourself as owner");
        this.add("item.extendedexchange.knowledge_sharing_book.tooltip.2", "Right-Click to copy knowledge from the book's owner to yourself");
        this.add("item.extendedexchange.knowledge_sharing_book.learned", "Knowledge copied! %d item(s) learned");
        this.add("item.extendedexchange.arcane_tablet.tooltip", "Portable Transmutation Tablet with built-in crafting functionality");
        this.add("gui.extendedexchange.arcane_tablet.rotate", "Rotate");
        this.add("gui.extendedexchange.arcane_tablet.balance", "Balance / Spread");
        this.add("gui.extendedexchange.arcane_tablet.clear", "Clear");
        this.add("gui.extendedexchange.link.tooltip.1", "Left-click: Extract stack");
        this.add("gui.extendedexchange.link.tooltip.2", "Right-click: Extract item");
        this.add("gui.extendedexchange.link.tooltip.3", "Shift + Right-click: Clear slot");
        this.add("extendedexchange.general.search_type", "Search Type");
        this.add("extendedexchange.general.search_type.normal", "Normal");
        this.add("extendedexchange.general.search_type.autoselected", "Auto-selected");
        this.add("extendedexchange.general.search_type.normal_jei_sync", "Normal (JEI Sync)");
        this.add("extendedexchange.general.search_type.autoselected_jei_sync", "Auto-selected (JEI Sync)");
    }
}

